' VB Script enabling Email functions on Groups or Users objects.    '
' Email can be enabled with or without an Exchange 2000 mailbox     '
' for a user object only.                                           '
'                                                                   '
' The Exchange 2000 mailbox creation via ADSI is a method not       '
' supported by Microsoft.                                           '
' CDO for Exchange Management must be used instead.                 '
'                                                                   '
' Version 1.01 - Alain Lissoir                                      '
' Compaq Computer Corporation - Professional Services - Belgium -   '
'                                                                   '
' Any comments or questions:         EMail:alain.lissoir@compaq.com '

Option Explicit

Const NO_CREATE_MB = 0
Const CREATE_MB = 1

' ------------------------------------------------------------------------------------------
Private Sub EnableEmailAddress (objObject, _
                                strExchangeComputer, _
                                strOrganization, _
                                strExchangeAdminGroup, _
                                strExchangeStorageGroup, _
                                strExchangeMailboxStore, _
                                boolMB)
Dim objRoot
Dim strRootDomainNC, objRootDomainNC
Dim strConfigNC

Dim strRootDNSDomainName
Dim strOrganizationDN
Dim strRecipient

Dim strSMTPAddress
Dim strX400Address
Dim strDefaultGAL
Dim strGroupGAL
Dim strLegacyExchangeDN

Dim strHomeMTA
Dim strHomeMDB
Dim strExchangeComputerDN

        Set ObjRoot = GetObject("LDAP://RootDSE")
        strRootDomainNC = objRoot.Get("RootDomainNamingContext")
        strConfigNC = ObjRoot.Get("configurationNamingContext")
        WScript.DisconnectObject ObjRoot
        Set ObjRoot = Nothing

        ' ----------------------------------------------------------------------------------
        Set objRootDomainNC = GetObject("LDAP://" & strRootDomainNC)

        ' Retrieve a constructed property, so 1st we do a GetInfoEx
        objRootDomainNC.GetInfoEx Array("canonicalName"), 0
        strRootDNSDomainName = objRootDomainNC.Get("canonicalName")
        ' Remove the / at the end
        strRootDNSDomainName = Mid (strRootDNSDomainName, 1, Len(strRootDNSDomainName) - 1)

        WScript.DisconnectObject objRootDomainNC
        Set objRootDomainNC = Nothing

        ' Build the path with the Microsoft Exchange organization path
        strOrganizationDN = "CN=" & strOrganization & _
                            ",CN=Microsoft Exchange,CN=Services," & strConfigNC

        ' ----------------------------------------------------------------------------------
        Select Case objObject.Class
               Case "user"
                    strRecipient = EliminateSpaces (LCase (objObject.FirstName) & _
                                                              "." & LCase (objObject.LastName))
                    ' Set the Alias name
                    objObject.put "mailNickName", strRecipient

                    ' Build the SMTP Address
                    strSMTPAddress = strRecipient & "@" & strRootDNSDomainName
                    ' Build the X400 Address
                    strX400Address = "c=" & strCountry & _
                                     ";a= " & _
                                     ";p=" & Left (strOrganization, 16) & _
                                     ";o=Exchange" & _
                                     ";s=" & LCase (objObject.LastName) & _
                                     ";g=" & LCase (objObject.FirstName) & _
                                     ";"

                    ' Set in which GAL to show the user
                    strDefaultGAL = "CN=Default Global Address List," & _
                                    "CN=All Global Address Lists,CN=Address Lists Container," & _
                                    strOrganizationDN
                    objObject.PutEx ADS_PROPERTY_UPDATE, "showInAddressBook", _
                                    Array(strDefaultGAL)

                    ' Set the legacy Exchange distinguished name of the created user
                    strLegacyExchangeDN = "/o=" & strOrganization & _
                                          "/ou=" & strExchangeAdminGroup & _
                                          "/cn=Recipients/cn=" & strRecipient

               Case "group"
                    strRecipient = EliminateSpaces (objObject.Get ("sAMAccountName"))

                    ' Set the Alias name
                    objObject.put "mailNickName", strRecipient

                    ' Build the SMTP Address
                    strSMTPAddress = strRecipient & "@" & strRootDNSDomainName
                    ' Build the X400 Address
                    strX400Address = "c=" & strCountry & _
                                     ";a= " & _
                                     ";p=" & Left (strOrganization, 16) & _
                                     ";o=Exchange" & _
                                     ";s=" & strRecipient & _
                                     ";"

                    ' Set in which GAL to show the group
                    strDefaultGAL = "CN=Default Global Address List," & _
                                    "CN=All Global Address Lists,CN=Address Lists Container," & _
                                    strOrganizationDN
                    strGroupGAL = "CN=All Groups,CN=All Address Lists," & _
                                  "CN=Address Lists Container," & _
                                  strOrganizationDN
                    objObject.PutEx ADS_PROPERTY_UPDATE, "showInAddressBook", _
                                    Array(strGroupGAL, strDefaultGAL)

                    ' Set the legacy Exchange distinguished name of the created group
                    strLegacyExchangeDN = "/o=" & strOrganization & _
                                          "/ou=" & strExchangeAdminGroup & _
                                          "/cn=Recipients/cn=" & strRecipient

               Case Else
                    Exit Sub
        End Select

        objObject.PutEx ADS_PROPERTY_UPDATE, "proxyAddresses", _
                        Array("X400:" & strX400Address, "SMTP:" & strSMTPAddress)

        ' Other LDAP value with X400 address
        objObject.put "textEncodedORAddress", strX400Address

        ' Other LDAP value with SMTP Address
        objObject.put "mail", strSMTPAddress

        objObject.put "msExchHideFromAddressLists", False

        objObject.put "legacyExchangeDN", strLegacyExchangeDN

        objObject.SetInfo

        ' ----------------------------------------------------------------------------------
        If (objObject.Class = "user" And boolMB) Then
           objObject.put "mDBUseDefaults", True

           strHomeMTA = "CN=Microsoft MTA,CN=" & strExchangeComputer & _
                        ",CN=Servers,CN=" & strExchangeAdminGroup & _
                        ",CN=Administrative Groups," & strOrganizationDN
           objObject.put "HomeMTA", strHomeMTA

           strHomeMDB = "CN=" & strExchangeMailboxStore & ",CN=" & _
                        strExchangeStorageGroup & _
                        ",CN=InformationStore,CN=" & strExchangeComputer & _
                        ",CN=Servers,CN=" & strExchangeAdminGroup & _
                        ",CN=Administrative Groups," & strOrganizationDN
           objObject.put "HomeMDB", strHomeMDB

           ' Set the Exchange Home server of the created user
           strExchangeComputerDN = "/o=" & strOrganization & _
                                   "/ou=" & strExchangeAdminGroup & _
                                   "/cn=Configuration/cn=Servers/cn=" & _
                                   strExchangeComputer
           objObject.put "msExchHomeServerName", strExchangeComputerDN
           objObject.SetInfo

           Wscript.Echo "  Successfully created Microsoft " & _
                        "Exchange 2000 Mailbox for user '" & _
                        objObject.Get ("cn") & "'."

           ' ------------------------------------------------------------------------------------------------
           ' Create the Exchange 2000 Security Descriptor
           SetSD objObject, _
                 Array ("Self", _
                              ADS_ACETYPE_ACCESS_ALLOWED, _
                              RIGHT_MB_READ_PERMISSIONS Or _
                               RIGHT_MB_FULL_MB_ACCESS Or _
                               RIGHT_MB_SEND_AS, _
                              CONTAINER_INHERIT_ACE), _
                 MB_OBJECT
        Else
           ' If mail-enabled object, initialize targetAddress with the SMTP Address
           objObject.put "targetAddress", "SMTP:" & strSMTPAddress

           ' Make this for the X400 address if necessary (instead of SMTP:)
           ' objObject.put "targetAddress", "X400:" & strX400Address
           objObject.SetInfo

           Wscript.Echo "  Successfully enabled Microsoft Exchange 2000 E-Mail for '" & _
                        objObject.Get ("cn") & "'."

        End If

End Sub

' ------------------------------------------------------------------------------------------
Function EliminateSpaces (strTemp)

Dim strNoSpaceName
Dim intIndice

        For intIndice = 1 To Len (strTemp)
            If Mid(strTemp, intIndice, 1) <> " " Then
               strNoSpaceName = strNoSpaceName & Mid(strTemp, intIndice, 1)
            End IF
        Next

        EliminateSpaces = strNoSpaceName

End Function